USE [msdb]
GO

/****** Object:  Job [DBA-SQL Overview - Get Active Logins and Login Failures]    Script Date: 01/21/2016 08:29:43 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 01/21/2016 08:29:43 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'DBA-SQL Overview - Get Active Logins and Login Failures', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=2, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Get Active Logins and Login Failures on all instances for Monaco and SPA2', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'SA', 
		@notify_email_operator_name=N'Kim Killian', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Get the data from the servers]    Script Date: 01/21/2016 08:29:44 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Get the data from the servers', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=N'/SQL "\ActiveUsersAndInvalidLogins" /SERVER SPA2 /CHECKPOINTING OFF /REPORTING E', 
		@database_name=N'master', 
		@output_file_name=N'E:\DBA\ActiveLoginsAndFailedLoginsErrors.txt', 
		@flags=0, 
		@proxy_name=N'SQLOverview_Cred'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Report  - Active User IDs]    Script Date: 01/21/2016 08:29:44 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Report  - Active User IDs', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Authorized User IDs''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) from SQL_Overview.dbo.AuthorizedUsers
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>ServerName</th>'' +
N''<th>UserID</th>'' +
N''<th>Role</th>'' +
N''<th>AccountType</th>'' +
N''<th>Run Date</th>'' +
N''</tr>'' +
CAST ( ( SELECT distinct td=[ServerName],''''
,td=[UserID],''''
,td=[Role],''''
,td=[AccountType],''''
,td=[RunDate],''''
FROM dbo.AuthorizedUsers
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''DBA'',
@recipients = ''SQLNotification@prattmiller.com'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END	', 
		@database_name=N'SQL_Overview', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Report - Get Failed Login Attempts]    Script Date: 01/21/2016 08:29:44 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Report - Get Failed Login Attempts', 
		@step_id=3, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Failed Login Attempts''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) from dbo.FailedLogins where LogDate >= GETDATE()-1
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>ServerName</th>'' +
N''<th>Text</th>'' +
N''<th>LogDate</th>'' +
N''</tr>'' +
CAST ( ( SELECT distinct td=[ServerName],''''
,td=[Text],''''
,td=[LogDate],''''
FROM dbo.FailedLogins where LogDate >= GETDATE()-1
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''DBA'',
@recipients = ''SQLNotification@prattmiller.com'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'SQL_Overview', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Daily', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=1, 
		@freq_subday_interval=0, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20160109, 
		@active_end_date=99991231, 
		@active_start_time=60000, 
		@active_end_time=235959, 
		@schedule_uid=N'1381aa14-de5e-4039-a92e-122f196e7ed8'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO


